CookieCompliance
=================


Adds drag and drop functionality to SilverStripe 4's GridField

## Requirements

* SilverStripe 4.x

## Installation

Installation is supported via composer only

```sh
composer require achilles/cookiecompliance
```

* Run `dev/build?flush=all` to regenerate the manifest
* Upon entering the cms and using `CookieCompliance` component for the first time you make need to add `?flush=all`
to the end of the address to force the templates to regenerate

## Usage

To enable sorting on a `has_many` relationship set up an integer field on your data object. Also for `has_many`
relationships make sure to set the `$default_sort` on the `DataObject` to this new integer field to ensure that the sort
order is applied when the relationship is requested. For `many_many` relationships you must add a 
`$many_many_extraFields` static to the `DataObject` defining the relationship, see the 
[SilverStripe documentation](https://docs.silverstripe.org/en/3/developer_guides/model/relations/#many-many) 
for more information on this. If you are using a `many_many` relationship you will need to do a custom getter to set the 
sort order of this relationship for use on the front end see below for an example. As well for `many_many` relationships
the name of the GridField *must* be the same as the relationship name other wise error's will occur. For new 
`DataObject`s you do not need to increment the sort order yourself in your `DataObject`, `GridFieldSortableRows` will
automatically do this the next time the grid is displayed.

```php
public function AbcFunction() {
    return ;
}
```



#### Full code Examples


```php
//Namespace imports should be added to the top of your file
use Achilles\CookieCompliance\\\\\\


```