<?php

use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Assets\File;
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\TextareaField;
use SilverStripe\Forms\HtmlEditor\HtmlEditorField;
use SilverStripe\Versioned\Versioned;

class ProductPage extends Page
{
    private static $db = [
        'Teaser' => 'Text',
        'Introduction' => 'HTMLText'
    ];

    private static $has_one = [
        'Thumbnail' => Image::class
    ];
    
    private static $owns = [
        'Thumbnail'
    ];
    
public function getCMSFields() 
  {
    $fields = parent::getCMSFields();
    $fields->addFieldToTab('Root.Main', UploadField::create('Thumbnail', 'Thumbnail (180x180)'), 'Content');
    $fields->addFieldToTab('Root.Main', TextareaField::create('Teaser'),'Content');
    
    $fields->addFieldToTab('Root.Main', HtmlEditorField::create('Introduction')->setRows(8),'Content');
    
    $fields->removeByName('MastHead');
    return $fields;
  }
}
