<?php

use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig_Base;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use UndefinedOffset\SortableGridField\Forms\GridFieldSortableRows;
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Versioned\Versioned;

class HomePage extends Page
{
    private static $db = [];

    private static $has_one = [
        
    ];
    
     private static $owns = [
        'Heroes'
    ];
    
   private static $has_many = [
        'Heroes' => Hero::class,
    ];
    
    public function getCMSFields() 
  {
    $fields = parent::getCMSFields();

  //  $fields->addFieldToTab('Root.Main', UploadField::create('Icon'), 'Content');
    $HeroField =  GridField::create(
            'Heroes',
            'Heroes on this page',
            $this->Heroes(),
            GridFieldConfig_RecordEditor::create()->addComponent(new GridFieldSortableRows('SortOrder'))
        );
  //  $IndustryField->addComponent(new GridFieldSortableRows('SortOrder'));
    $fields->addFieldToTab('Root.Heroes',$HeroField);
    $fields->removeByName('MastHead');
    return $fields;
  }
}

class Hero extends DataObject{
   private static $extensions = [
        Versioned::class
    ];
    
    private static $db = [
         'Title' => 'Text',
         'Content' => 'HTMLText',
         'SortOrder' => 'Int',
         'Active' => 'Boolean'
    ];
    
    private static $has_one = [
        'BackgroundImage' => Image::class,

        'HomePage' => HomePage::class,
    ]; 
    
    private static $owns = [
        'BackgroundImage'
    ];
    
   private static $summary_fields = [
         'Title' => 'Title',
         'SortOrder' => 'Sort Order',
         'Active' => 'Active'
    ];
}
