<?php

use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Assets\File;
use SilverStripe\Assets\Image;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig_Base;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\ORM\DataObject;
use UndefinedOffset\SortableGridField\Forms\GridFieldSortableRows;
use SilverStripe\Versioned\Versioned;

class ClientPage extends Page
{
    private static $db = [

    ];

    private static $has_one = [
 
    ];
    
    private static $has_many = [
        'Clients' => Client::class,
    ];
    
    private static $owns = [
        'Clients'
    ];   
    
public function getCMSFields() 
  {
    $fields = parent::getCMSFields();

  //  $fields->addFieldToTab('Root.Main', UploadField::create('Icon'), 'Content');
    $ClientField =  GridField::create(
            'Clients',
            'Clients',
            $this->Clients(),
            GridFieldConfig_RecordEditor::create()->addComponent(new GridFieldSortableRows('SortOrder'))
        );
  //  $IndustryField->addComponent(new GridFieldSortableRows('SortOrder'));
    $fields->addFieldToTab('Root.Clients',$ClientField);
    
    return $fields;
  }
}


class Client extends DataObject{
    private static $extensions = [
        Versioned::class
    ];
    
    private static $db = [
         'Title' => 'Text',
         'Description' => 'HTMLText',
         'Link' => 'Text',
         'SortOrder' => 'Int',
         'Active' => 'Boolean'
    ];
    
    private static $has_one = [
        'Logo' => Image::class,
        'ClientPage' => ClientPage::class,
    ];
    
    private static $summary_fields = [
        'Title' => 'Title',
        'Active' => 'Active',
        'SortOrder' => 'Sort Order'
    ];
    
    private static $owns = [
        'Logo'
    ];
    
}